/*
 * Decompiled with CFR 0.152.
 */
package fisi.unsm.api.controller;

import fisi.unsm.api.entity.CategoriasCurso;
import fisi.unsm.api.service.ICategoriasCursoService;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/restful"})
public class CategoriasCursoController {
    @Autowired
    private ICategoriasCursoService serviceCategoriasCurso;

    @GetMapping(value={"/categoriascurso"})
    public List<CategoriasCurso> buscartodos() {
        return this.serviceCategoriasCurso.buscarTodos();
    }

    @PostMapping(value={"/categoriascurso"})
    public CategoriasCurso guardar(@RequestBody CategoriasCurso curso) {
        this.serviceCategoriasCurso.guardar(curso);
        return curso;
    }

    @PutMapping(value={"/categoriascurso"})
    public CategoriasCurso modificar(@RequestBody CategoriasCurso curso) {
        this.serviceCategoriasCurso.modificar(curso);
        return curso;
    }

    @GetMapping(value={"/categoriascurso/{id}"})
    public Optional<CategoriasCurso> buscarId(@PathVariable(value="id") Integer id) {
        return this.serviceCategoriasCurso.buscarId(id);
    }

    @DeleteMapping(value={"/categoriascurso/{id}"})
    public String eliminar(@PathVariable Integer id) {
        this.serviceCategoriasCurso.eliminar(id);
        return "Categor\u00eda de curso eliminado";
    }
}

