/*
 * Decompiled with CFR 0.152.
 */
package fisi.unsm.api.controller;

import fisi.unsm.api.entity.NaturalezasCurso;
import fisi.unsm.api.service.INaturalezasCursoService;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/restful"})
public class NaturalezasCursoController {
    @Autowired
    private INaturalezasCursoService serviceNaturalezasCurso;

    @GetMapping(value={"/naturalezascurso"})
    public List<NaturalezasCurso> buscartodos() {
        return this.serviceNaturalezasCurso.buscarTodos();
    }

    @PostMapping(value={"/naturalezascurso"})
    public NaturalezasCurso guardar(@RequestBody NaturalezasCurso curso) {
        this.serviceNaturalezasCurso.guardar(curso);
        return curso;
    }

    @PutMapping(value={"/naturalezascurso"})
    public NaturalezasCurso modificar(@RequestBody NaturalezasCurso curso) {
        this.serviceNaturalezasCurso.modificar(curso);
        return curso;
    }

    @GetMapping(value={"/naturalezascurso/{id}"})
    public Optional<NaturalezasCurso> buscarId(@PathVariable(value="id") Integer id) {
        return this.serviceNaturalezasCurso.buscarId(id);
    }

    @DeleteMapping(value={"/naturalezascurso/{id}"})
    public String eliminar(@PathVariable Integer id) {
        this.serviceNaturalezasCurso.eliminar(id);
        return "Naturaleza de curso eliminado";
    }
}

