/*
 * Decompiled with CFR 0.152.
 */
package fisi.unsm.api.controller;

import fisi.unsm.api.entity.TiposCurso;
import fisi.unsm.api.service.ITiposCursoService;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/restful"})
public class TiposCursoController {
    @Autowired
    private ITiposCursoService serviceTiposCurso;

    @GetMapping(value={"/tiposcurso"})
    public List<TiposCurso> buscartodos() {
        return this.serviceTiposCurso.buscarTodos();
    }

    @PostMapping(value={"/tiposcurso"})
    public TiposCurso guardar(@RequestBody TiposCurso curso) {
        this.serviceTiposCurso.guardar(curso);
        return curso;
    }

    @PutMapping(value={"/tiposcurso"})
    public TiposCurso modificar(@RequestBody TiposCurso curso) {
        this.serviceTiposCurso.modificar(curso);
        return curso;
    }

    @GetMapping(value={"/tiposcurso/{id}"})
    public Optional<TiposCurso> buscarId(@PathVariable(value="id") Integer id) {
        return this.serviceTiposCurso.buscarId(id);
    }

    @DeleteMapping(value={"/tiposcurso/{id}"})
    public String eliminar(@PathVariable Integer id) {
        this.serviceTiposCurso.eliminar(id);
        return "Tipo de curso eliminado";
    }
}

