/*
 * Decompiled with CFR 0.152.
 */
package fisi.unsm.api.entity;

import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Table;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.hibernate.annotations.SQLDelete;
import org.hibernate.annotations.Where;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;

@Entity
@Table(name="registros")
@SQLDelete(sql="UPDATE registros SET estado=0 WHERE idregistro=?")
@Where(clause="estado = 1")
public class Registros {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Integer idregistro;
    private String nombres;
    private String apellidos;
    private String email;
    private String cliente_id;
    private String llave_secreta;
    private String access_token;
    private Integer estado = 1;

    public Integer getIdregistro() {
        return this.idregistro;
    }

    public void setIdregistro(Integer idregistro) {
        this.idregistro = idregistro;
    }

    public String getNombres() {
        return this.nombres;
    }

    public void setNombres(String nombres) {
        this.nombres = nombres;
    }

    public String getApellidos() {
        return this.apellidos;
    }

    public void setApellidos(String apellidos) {
        this.apellidos = apellidos;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getCliente_id() {
        return this.cliente_id;
    }

    public void setCliente_id(String cliente_id) {
        String result;
        String datos = this.nombres + this.apellidos + this.email;
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        md.update(datos.getBytes());
        byte[] digest = md.digest();
        this.cliente_id = cliente_id = (result = new BigInteger(1, digest).toString(16).toLowerCase());
    }

    public String getLlave_secreta() {
        return this.llave_secreta;
    }

    public void setLlave_secreta(String llave_secreta) {
        BCryptPasswordEncoder encoder = new BCryptPasswordEncoder();
        this.llave_secreta = encoder.encode((CharSequence)llave_secreta);
    }

    public Integer getEstado() {
        return this.estado;
    }

    public void setEstado(Integer estado) {
        this.estado = estado;
    }

    public String getAccess_token() {
        return this.access_token;
    }

    public void setAccess_token(String access_token) {
        this.access_token = access_token;
    }

    public String toString() {
        return "Registros [idregistro=" + String.valueOf(this.idregistro) + ", nombres=" + this.nombres + ", apellidos=" + this.apellidos + ", email=" + this.email + ", cliente_id=" + this.cliente_id + ", llave_secreta=" + this.llave_secreta + ", access_token=" + this.access_token + ", estado=" + String.valueOf(this.estado) + "]";
    }
}

